/*
 ============================================================================
 Name        : ProjectKernel.c
 Author      :
 Version     :
 Copyright   :
 Description : Detects button presses and sends the number of the button
			   to the user space program.
 ============================================================================
 */

#ifndef MODULE
#define MODULE
#endif

#ifndef __KERNEL__
#define __KERNEL__
#endif

#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/io.h>
#include <unistd.h>
#include <rtai_fifos.h>
#include <rtai_sched.h>

MODULE_LICENSE("GPL");

unsigned long *ptr1;

static void my_handler(unsigned irq_num, void *cookie){
	unsigned long *bEOI, *bRawSts, *pbdr;
	static int button[5] = {1, 2, 3, 4, 5};

	pbdr = (unsigned long *)((char *)ptr1 + 0x04); //Port B Data Register
	bEOI = (unsigned long *)((char *)ptr1 + 0xB4); //GPIOBEOI
	bRawSts = (unsigned long *)((char*)ptr1 + 0xC0); //RawIntStsB

	//disable interrupt
	rt_disable_irq(59);

	//if B0 pressed, writes 1 to fifo
	if((*bRawSts & (1 << 0)) == 0x01){
		printk("button 1 interrupt\n");
		*pbdr = *pbdr & 0xFFFFFF1F;
		*pbdr = *pbdr | 0x80;

		rtf_put(1, &button[0], sizeof(int));
	}
	//if B1 pressed, writes 2 to fifo
	else if((*bRawSts & (1 << 1)) == 0x02){
		printk("button 2 interrupt\n");
		*pbdr = *pbdr & 0xFFFFFF1F;
		*pbdr = *pbdr | 0x40;

		rtf_put(1, &button[1], sizeof(int));
	}
	//if B2 pressed, writes 3 to fifo
	else if((*bRawSts & (1 << 2)) == 0x04){
		printk("button 3 interrupt\n");
		*pbdr = *pbdr & 0xFFFFFF1F;
		*pbdr = *pbdr | 0xC0;

		rtf_put(1, &button[2], sizeof(int));
	}
	//if B3 pressed, writes 4 to fifo
	else if((*bRawSts & (1 << 3)) == 0x08){
		printk("button 4 interrupt\n");
		*pbdr = *pbdr & 0xFFFFFF1F;
		*pbdr = *pbdr | 0x20;

		rtf_put(1, &button[3], sizeof(int));
	}
	//if B4 pressed, writes 5 to fifo
	else if((*bRawSts & (1 << 4)) == 0x10){
		printk("button 5 interrupt\n");
		*pbdr = *pbdr & 0xFFFFFF1F;
		*pbdr = *pbdr | 0xA0;

		rtf_put(1, &button[4], sizeof(int));
	}

	*bEOI = *bEOI | 0x1F; //clear interrupt

	rt_enable_irq(59); //enable interrupt
}

int init_module(void){
	unsigned long *pbdr, *pbddr;
	unsigned long *bEnable, *bType1, *bType2, *bDebounce, *bEOI;

	
	ptr1 = (unsigned long *)__ioremap(0x80840000, 4096, 0);

	pbdr = (unsigned long *)((char *)ptr1 + 0x04);		//Port B Data
	pbddr = (unsigned long *)((char *)ptr1 + 0x14);		//Port B Data Direction
	bType1 = (unsigned long *)((char *)ptr1 + 0xAC);  	//GPIOBIntType1
	bType2 = (unsigned long *)((char *)ptr1 + 0xB0);	//GPIOBIntType2
	bEnable = (unsigned long *)((char *)ptr1 + 0xB8); 	//GPIOBIntEn
	bDebounce = (unsigned long *)((char *)ptr1 + 0xC4); //GPIOBDB
	bEOI = (unsigned long *)((char *)ptr1 + 0xB4);		//GPIOBEOI

	*pbddr = *pbddr | 0xE0; //set buttons as inputs, LEDs as outputs
	*pbdr = *pbdr & 0xFFFFFF1F; //turn off lights

	rtf_create(1, sizeof(int)); //create fifo

	rt_request_irq(59, my_handler, 0, 1); //attach handler to interrupt line

	*bEnable = *bEnable & 0xFFFFFFE0;
	*bType1 = *bType1 | 0x1F;			//edge sensitive
	*bType2 = *bType2 & 0xFFFFFFE0;		//falling edge
	*bDebounce = *bDebounce | 0x1F;		//enable debounce
	*bEOI = *bEOI | 0x1F;				//clear interrupts
	*bEnable = *bEnable | 0x1F;

	rt_enable_irq(59); //enable interrupt

	return 0;
}

void cleanup_module(void){
	unsigned long *pbdr, *pbddr;
	unsigned long *bEnable, *bType1, *bType2, *bDebounce, *bEOI;

	pbdr = (unsigned long *)((char *)ptr1 + 0x04);		//Port B Data
	pbddr = (unsigned long *)((char *)ptr1 + 0x14);		//Port B Data Direction
	bType1 = (unsigned long *)((char *)ptr1 + 0xAC);  	//GPIOBIntType1
	bType2 = (unsigned long *)((char *)ptr1 + 0xB0);	//GPIOBIntType2
	bEnable = (unsigned long *)((char *)ptr1 + 0xB8); 	//GPIOBIntEn
	bDebounce = (unsigned long *)((char *)ptr1 + 0xC4); //GPIOBDB
	bEOI = (unsigned long *)((char *)ptr1 + 0xB4);		//GPIOBEOI

	*pbddr = *pbddr | 0xE0; //set buttons as inputs, LEDs as outputs
	*pbdr = 0xFFFFFF1F; //turn off lights

	rt_release_irq(59);
	rtf_destroy(1);
}
